///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	This file contains the exportation settings structure.
 *	\file		FLX_ExportSettings.h
 *	\author		Pierre Terdiman
 *	\date		April, 4, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __FLX_EXPORTSETTINGS_H__
#define __FLX_EXPORTSETTINGS_H__

	//! Various compression schemes
	enum CompressionValues
	{
		COMPRESSION_NONE		= 0,
		COMPRESSION_ZLIB		= 1,
		COMPRESSION_BZIP2		= 2,
		COMPRESSION_FORCE_DWORD	= 0x7fffffff,
	};

	//! Exportation settings. You can here customize the way Flexporter exports information from MAX.
	class ExportSettings
	{
		public:
		// Constructor / Destructor
									ExportSettings()
									{
										mNbBits						= 8;
										mExportWholeScene			= true;
										mExportVisTrack				= false;
										mExportHiddenNodes			= false;
										mExportPHYSIQUE				= true;
										mExportBIPED				= false;
										mAlwaysExportMotion			= false;

										mExpUVW						= false;
										mDiscardW					= true;
										mExpVTXColor				= false;
										mUseSmgrp					= true;
										mRemoveScaling				= true;
										mConvertToD3D				= true;
										mAbsolutePRS				= false;
										mConvexHull					= false;
										mBoundingSphere				= false;
										mInertiaTensor				= false;
										mEdgeVis					= false;
										mMakeManifold				= false;
										mExpTargetNodes				= false;

										mConsolidateMesh			= false;
										mComputeFaceNormals			= false;
										mComputeVertexNormals		= false;
										mExportNormalInfo			= false;
										mWeightNormalsByArea		= false;

										mForceAmbient				= false;
										mForceDiffuse				= false;
										mExpMtlCtrl					= false;

										mOpacityInAlpha				= true;
										mTexnameOnly				= false;
										mTexMaxSize					= 256;
										mKeepAmbientTexture			= false;
										mKeepDiffuseTexture			= true;
										mKeepSpecularTexture		= false;
										mKeepShininessTexture		= false;
										mKeepShiningStrengthTexture	= false;
										mKeepSelfIllumTexture		= false;
										mKeepOpacityTexture			= true;
										mKeepFilterTexture			= false;
										mKeepBumpTexture			= false;
										mKeepReflexionTexture		= false;
										mKeepRefractionTexture		= false;
										mKeepDisplacementTexture	= false;
										mFlipHorizontal				= false;
										mFlipVertical				= false;
										mQuantizeTextures			= false;

										mExpCameras					= true;
										mExpFOVCtrl					= false;
										mExpCamCtrl					= false;

										mExpLights					= true;
										mExpLitCtrl					= false;
										mComputeVtxColors			= false;
										mComputeShadows				= false;
										mColorSmoothing				= false;

										mSingleFrame				= true;
										mSampling					= true;
										mSamplingRate				= 1;

										mExpShapes					= false;
										mExpHelpers					= false;
									}

									~ExportSettings()
									{
									}

		__forceinline	long		GetSamplingRate()			{ return mSamplingRate>0 ? mSamplingRate : 1;	}

		// General settings
						udword		mCompression;					//!< Compression settings (see above)
						long		mNbBits;						//!< Number of bits / quantized coordinate
						bool		mExportWholeScene;				//!< Export whole scene or single node
						bool		mExportVisTrack;				//!< Export visibility track
						bool		mExportHiddenNodes;				//!< Export hidden nodes or discard them
						bool		mExportPHYSIQUE;				//!< Export PHYSIQUE parts as skins (else as standard meshes)
						bool		mExportBIPED;					//!< Export BIPED parts or discard them
						bool		mAlwaysExportMotion;			//!< Export motion data in main file
		// Meshes settings
				//		bool		mCreateStrips;					//!< Create triangle strips or not
						bool		mExpUVW;						//!< Export UVW mappings or discard them
						bool		mDiscardW;						//!< Discard W in UVW or keep it
						bool		mExpVTXColor;					//!< Export vertex colors or discard them
						bool		mUseSmgrp;						//!< Use smoothing groups or discard them
				//		bool		mExpNorm;						//!< Export normals or not
				//		bool		mLOD;							//!< Compute progressive meshes or not
						bool		mRemoveScaling;					//!< Remove non-uniform scaling of all nodes
						bool		mConvertToD3D;					//!< Convert from MAX frame to D3D frame
						bool		mAbsolutePRS;					//!< Export absolute PRS values (else relative to parent)
						bool		mConvexHull;					//!< Flexporter can compute the convex hull for you
						bool		mBoundingSphere;				//!< Flexporter can compute the bounding sphere for you
						bool		mInertiaTensor;					//!< Flexporter can compute the inertia tensor for you
						bool		mEdgeVis;						//!< Export edge visibility
						bool		mMakeManifold;					//!< Make manifold mesh (remove singular edges)
						bool		mExpTargetNodes;				//!< Export target nodes or discard them
		// Consolidation settings
						bool		mConsolidateMesh;				//!< Flexporter can rebuild a clean mesh for you
						bool		mComputeFaceNormals;			//!< Flexporter can compute and export face normals
						bool		mComputeVertexNormals;			//!< Flexporter can compute and export vertex normals
						bool		mExportNormalInfo;				//!< Export NormalInfo field or not
						bool		mWeightNormalsByArea;			//!< Take face areas into account in normal computation
		// Material settings
						bool		mForceAmbient;					//!< Force material ambient color to pure white.
						bool		mForceDiffuse;					//!< Force material diffuse color to pure white.
						bool		mExpMtlCtrl;					//!< Export material controllers or discard them
		// Texture settings
						bool		mOpacityInAlpha;				//!< Pack the opacity map in the diffuse map alpha channel
						bool		mTexnameOnly;					//!< Only reports the texture's name, not the pixel buffer
						udword		mTexMaxSize;					//!< Texture maximum size
						bool		mKeepAmbientTexture;			//!< Export ambient textures, or discard them
						bool		mKeepDiffuseTexture;			//!< Export diffuse textures, or discard them
						bool		mKeepSpecularTexture;			//!< Export specular textures, or discard them
						bool		mKeepShininessTexture;			//!< Export shininess textures, or discard them
						bool		mKeepShiningStrengthTexture;	//!< Export shining strength textures, or discard them
						bool		mKeepSelfIllumTexture;			//!< Export self-illum textures, or discard them
						bool		mKeepOpacityTexture;			//!< Export opacity textures, or discard them
						bool		mKeepFilterTexture;				//!< Export filter textures, or discard them
						bool		mKeepBumpTexture;				//!< Export bump textures, or discard them
						bool		mKeepReflexionTexture;			//!< Export reflexion textures, or discard them
						bool		mKeepRefractionTexture;			//!< Export refraction textures, or discard them
						bool		mKeepDisplacementTexture;		//!< Export displacement textures, or discard them
						bool		mFlipHorizontal;				//!< Flip texture horizontally before exporting
						bool		mFlipVertical;					//!< Flip texture vertically before exporting
						bool		mQuantizeTextures;				//!< Convert to 256-colors textures
		// Camera settings
						bool		mExpCameras;					//!< Export cameras or discard them
						bool		mExpFOVCtrl;					//!< Export FOV controller or discard them
						bool		mExpCamCtrl;					//!< Export cameras attributes controllers or discard them
		// Light settings
						bool		mExpLights;						//!< Export lights or discard them
						bool		mExpLitCtrl;					//!< Export lights attributes controllers or discard them
						bool		mComputeVtxColors;				//!< Pack lighting in vertex colors
						bool		mComputeShadows;				//!< Compute shadows or not
						bool		mColorSmoothing;				//!< Extra color smoothing pass (reduce aliasing)
		// Animation settings
						bool		mSingleFrame;					//!< Export a single frame
						bool		mSampling;						//!< Export samples (true) or keyframes (false)
						long		mSamplingRate;					//!< Sampling rate
		// Shape settings
						bool		mExpShapes;						//!< Export shapes or discard them
		// Helper settings
						bool		mExpHelpers;					//!< Export helpers or discard them
	};

	//! Settings enabled/disabled status
	class Enabled
	{
		public:
		// Constructor / Destructor
									Enabled()
									{
										// Default: everything is enabled
										mCompression				= true;
										mExportWholeScene			= true;
										mExportVisTrack				= true;
										mExportHiddenNodes			= true;
										mExportPHYSIQUE				= true;
										mExportBIPED				= true;
										mAlwaysExportMotion			= true;

										mExpUVW						= true;
										mDiscardW					= true;
										mExpVTXColor				= true;
										mUseSmgrp					= true;
										mRemoveScaling				= true;
										mConvertToD3D				= true;
										mAbsolutePRS				= true;
										mConvexHull					= true;
										mBoundingSphere				= true;
										mInertiaTensor				= true;
										mEdgeVis					= true;
										mMakeManifold				= true;
										mExpTargetNodes				= true;

										mConsolidateMesh			= true;
										mComputeFaceNormals			= true;
										mComputeVertexNormals		= true;
										mExportNormalInfo			= true;
										mWeightNormalsByArea		= true;

										mForceAmbient				= true;
										mForceDiffuse				= true;
										mExpMtlCtrl					= true;

										mOpacityInAlpha				= true;
										mTexnameOnly				= true;
										mTexMaxSize					= true;
										mKeepAmbientTexture			= true;
										mKeepDiffuseTexture			= true;
										mKeepSpecularTexture		= true;
										mKeepShininessTexture		= true;
										mKeepShiningStrengthTexture	= true;
										mKeepSelfIllumTexture		= true;
										mKeepOpacityTexture			= true;
										mKeepFilterTexture			= true;
										mKeepBumpTexture			= true;
										mKeepReflexionTexture		= true;
										mKeepRefractionTexture		= true;
										mKeepDisplacementTexture	= true;
										mFlipHorizontal				= true;
										mFlipVertical				= true;
										mQuantizeTextures			= true;

										mExpCameras					= true;
										mExpFOVCtrl					= true;
										mExpCamCtrl					= true;

										mExpLights					= true;
										mExpLitCtrl					= true;
										mComputeVtxColors			= true;
										mComputeShadows				= true;
										mColorSmoothing				= true;

										mSingleFrame				= true;
										mSampling					= true;
										mSamplingRate				= true;

										mExpShapes					= true;
										mExpHelpers					= true;
									}

									~Enabled()
									{
									}

		// General permissions
						bool		mCompression;					//!< Enable/disable compression
						bool		mExportWholeScene;				//!< ...
						bool		mExportVisTrack;				//!< 
						bool		mExportHiddenNodes;				//!< 
						bool		mExportPHYSIQUE;				//!< 
						bool		mExportBIPED;					//!< 
						bool		mAlwaysExportMotion;			//!< 
		// Meshes permissions
						bool		mExpUVW;						//!< 
						bool		mDiscardW;						//!< 
						bool		mExpVTXColor;					//!< 
						bool		mUseSmgrp;						//!< 
						bool		mRemoveScaling;					//!< 
						bool		mConvertToD3D;					//!< 
						bool		mAbsolutePRS;					//!< 
						bool		mConvexHull;					//!< 
						bool		mBoundingSphere;				//!< 
						bool		mInertiaTensor;					//!< 
						bool		mEdgeVis;						//!< 
						bool		mMakeManifold;					//!< 
						bool		mExpTargetNodes;				//!< 
		// Consolidation permissions
						bool		mConsolidateMesh;				//!< 
						bool		mComputeFaceNormals;			//!< 
						bool		mComputeVertexNormals;			//!< 
						bool		mExportNormalInfo;				//!< 
						bool		mWeightNormalsByArea;			//!< 
		// Material permissions
						bool		mForceAmbient;					//!< 
						bool		mForceDiffuse;					//!< 
						bool		mExpMtlCtrl;					//!<
		// Texture permissions
						bool		mOpacityInAlpha;				//!< 
						bool		mTexnameOnly;					//!< 
						bool		mTexMaxSize;					//!< 
						bool		mKeepAmbientTexture;			//!< 
						bool		mKeepDiffuseTexture;			//!< 
						bool		mKeepSpecularTexture;			//!< 
						bool		mKeepShininessTexture;			//!< 
						bool		mKeepShiningStrengthTexture;	//!< 
						bool		mKeepSelfIllumTexture;			//!< 
						bool		mKeepOpacityTexture;			//!< 
						bool		mKeepFilterTexture;				//!< 
						bool		mKeepBumpTexture;				//!< 
						bool		mKeepReflexionTexture;			//!< 
						bool		mKeepRefractionTexture;			//!< 
						bool		mKeepDisplacementTexture;		//!< 
						bool		mFlipHorizontal;				//!< 
						bool		mFlipVertical;					//!< 
						bool		mQuantizeTextures;				//!< 
		// Camera permissions
						bool		mExpCameras;					//!< 
						bool		mExpFOVCtrl;					//!< 
						bool		mExpCamCtrl;					//!<
		// Light permissions
						bool		mExpLights;						//!< 
						bool		mExpLitCtrl;					//!<
						bool		mComputeVtxColors;				//!< 
						bool		mComputeShadows;				//!< 
						bool		mColorSmoothing;				//!< 
		// Animation permissions
						bool		mSingleFrame;					//!< 
						bool		mSampling;						//!< 
						bool		mSamplingRate;					//!< 
		// Shape permissions
						bool		mExpShapes;						//!< 
		// Helper permissions
						bool		mExpHelpers;					//!< 
	};

#endif // __FLX_EXPORTSETTINGS_H__
